<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class ReferecementUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'pageCible' => 'required',
            'siteTitle' => 'required',
            'meta_keywords' => 'required',
            'meta_description' => 'required',
            'meta_robots' => 'required',
            'meta_category' => 'required',
            'meta_identifier_url' => 'required',
            'meta_reply_to' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'pageCible.required' => 'Le champ page cible est obligatoire',
            'siteTitle.required' => 'Le champ siteTitle est obligatoire',
            'meta_keywords.required' => 'Le champ meta_keywords est obligatoire',
            'meta_description.required' => 'Le champ meta_description est obligatoire',
            'meta_robots.required' => 'Le champ meta_robots est obligatoire',
            'meta_category.required' => 'Le champ meta_category est obligatoire',
            'meta_identifier_url.required' => 'Le champ meta_identifier_url est obligatoire',
            'meta_reply_to.required' => 'Le champ meta_reply_to est obligatoire',
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(response()->json([
            'status' => 'failed',
            'response' => $validator->errors()
        ], 422));
    }
}
