<?php

namespace Database\Seeders;

use App\Models\Certificat;
use App\Models\Entreprise;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        User::factory()->create([
            'nom' => 'DKBSign',
            'prenoms' => 'Admin',
            'role' => User::ROLE_ADMIN,
            'email' => 'admin@dkbsign.com',
            'password' => '$2y$10$nDqxVHwxdpfLBLYc/KAt5OPI9kg7JtLSRce74pcymqE3zuenh5REO'
        ]);

        $certificat = Certificat::factory()->create([
            'intitule' => 'Certificat Demo',
            'cle_api' => 'test@dkbsign7',
            'cle_securite' => 'DH9QhgopYgZ0VyQNSVjd9k5b4S2i78ng781407RrlAolzMAeQYwVSYLNA==',
            'date_expiration' => now()->endOfYear()->toDateString()
        ]);

        $entreprise = Entreprise::factory()
            ->for($certificat)
            ->create([
                'raison_sociale' => 'DKBSign',
                'email' => 'infos@dkbsign.com',
                'telephone' => '2722464724'
            ]);
            
        User::factory()
            ->for($entreprise)
            ->create([
                'email' => 'demo@dkbsign.com',
                'telephone' => '0000000001',
                'signer' => 1,
                'faire_signer' => 1,
                'signer_faire_signer' => 1
            ]);
    }
}
