<?php

use App\Models\Signataire;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('signataires', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')
                ->constrained()
                ->cascadeOnDelete();
            $table->string('nom')->nullable();
            $table->string('telephone')->nullable();
            $table->string('email')->nullable();
            $table->string('document');
            $table->string('statut')->default(Signataire::STATUT_EN_ATTENTE);
            $table->integer('ordre')->default(0);
            $table->integer('positionX')->nullable();
            $table->integer('positionY')->nullable();
            $table->integer('page')->nullable();
            $table->integer('code_auth')->nullable();
            $table->text('motif')->nullable();
            $table->timestamps();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('signataires');
        Schema::enableForeignKeyConstraints();
    }
};
