<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Certificat>
 */
class CertificatFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'intitule' => $this->faker->sentence(),
            'cle_api' => Str::random(10),
            'cle_securite' => Str::random(10),
            'date_expiration' => now()->toDateString(),
            'volume_signatures_total' => rand(100000, 1000000),
            'volume_signatures_restant' => rand(100000, 1000000)
        ];
    }
}
