<?php

namespace App\Notifications\RenouvellementCertificatNotification;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class AdminNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(
        public int $remainingWeeks, 
        public string $entreprise
    ) {}

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Renouvellement de certificat')
            ->from('no-reply@dkbsign.com', 'DKB Sign')
            ->line("Le certificat de l'entreprise " . $this->entreprise . " expire dans " . $this->remainingWeeks . " semaine(s).")
            ->line('Merci de contacter le service client afin de procéder au renouvellement de votre certificat.')
            ->line("DKB Sign est une solution de DKBS, PSCE agréé par l'ARTCI");
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
