<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Signataire extends Model
{
    use HasFactory;

    public const STATUT_EN_ATTENTE = 'en_attente';
    public const STATUT_SIGNE = 'signe';
    public const STATUT_REFUSE = 'refuse';
    public const STATUT_EN_COURS = 'en_cours';

    protected $fillable = [
        'user_id',
        'nom',
        'telephone',
        'email',
        'document',
        'statut',
        'ordre',
        'consulte',
        'positionX',
        'positionY',
        'page',
        'code_auth',
        'motif',
    ];

    public static function getStatuts(): array
    {
        return [
            self::STATUT_EN_ATTENTE,
            self::STATUT_SIGNE,
            self::STATUT_REFUSE,
            self::STATUT_EN_COURS
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
