<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class AcceptedSignatureNotification extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(
        public string $url,
        public string $recipient,
        public string $document
    ) {}

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject("Document accepté d'être signé")
            ->from('no-reply@dkbsign.com', 'DKBSign')
            ->markdown('mail.signature.accepted', [
                'url' => $this->url,
                'recipient' => $this->recipient,
                'document' => $this->document
            ]);
    }
}
