<?php

namespace App\Http\UseCases\Api\SMS;

use App\Http\Services\SMSService;
use App\Models\Signataire;

final class StoreUseCase
{
    public function __construct(
        private SMSService $smsService
    ) {}

    public function handle(string $telephone)
    {
        $codeAuth = rand(1000, 9999);

        Signataire::query()
            ->where('telephone', $telephone)
            ->where('statut', Signataire::STATUT_EN_ATTENTE)
            ->update(['code_auth' => $codeAuth]);

        $signataire = Signataire::query()
            ->where('telephone', $telephone)
            ->first();

        return $this->smsService->send(
            $telephone, 
            $codeAuth, 
            $signataire->user->getFullName(), 
            $signataire->email
        );
    }
}
