<?php

namespace App\Http\UseCases\Api\Notification;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Notification;
use App\Models\User;
use App\Notifications\CustomMessageNotification;
use Exception;
use Illuminate\Http\JsonResponse;

final class StoreUseCase extends AbstractUseCase
{
    public function handle(User $user, array $data): JsonResponse
    {
        $notification = Notification::factory()
            ->for($user)
            ->create($data);

        try {
            $user->notify(
                new CustomMessageNotification($data['message'], 'https://dkbsign.com')
            );
        } catch (Exception $e) {}

        return $notification
            ? $this->success('La notification a été enregistrée avec succès')
            : $this->error("Echec de l'enregistrement de la notification", 400);
    }
}
