<?php

namespace App\Http\UseCases\Api\Notification;

use App\Http\Resources\NotificationCollection;
use App\Models\Notification;
use App\Models\User;

final class GetCollectionUseCase
{
    public function handle(User $user, ?int $limit = null, ?int $page = null): NotificationCollection
    {
        return new NotificationCollection(
            Notification::query()
                ->where('user_id', $user)
                ->orderBy('created_at', 'desc')
                ->paginate($limit, ['*'], 'page', $page)
        );
    }
}
