<?php

namespace App\Http\UseCases\Api\Entreprise;

use App\Http\Resources\UserCollection;
use App\Models\Entreprise;
use App\Models\User;

final class GetUserCollectionUseCase
{
    public function handle(Entreprise $entreprise, ?int $page = null, ?int $limit = null): UserCollection
    {
        return new UserCollection(
            User::query()
                ->where('entreprise_id', $entreprise)
                ->orderBy('created_at', 'desc')
                ->paginate($limit, ['*'], 'page', $page)
        );
    }
}
