<?php

namespace App\Http\UseCases\Api\Contact;

use App\Http\Services\FileUploadService;
use App\Http\UseCases\Api\AbstractUseCase;
use App\Imports\ContactsImport;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\UploadedFile;

final class ImportUseCase extends AbstractUseCase
{
    public function __construct(
        private FileUploadService $fileUploadService
    ) {}

    public function handle(User $user, UploadedFile $file): JsonResponse
    {
        (new ContactsImport($user->id))->import($file);
        return $this->success('Contacts importés avec succès');
    }
}
