<?php

namespace App\Http\UseCases\Api\Certificat;

use App\Http\Resources\CertificatCollection;
use App\Models\Certificat;

final class GetCollectionUseCase
{
    public function handle(?int $page = null, ?int $limit = null, ?string $search = null): CertificatCollection
    {
        $query = Certificat::query()
            ->orderBy('created_at', 'desc')
            ->when(!is_null($search), function ($q) use ($search) {
                return $q->where('intitule', 'like', "%$search%")
                    ->orWhere('cle_api', 'like', "%$search%")
                    ->orWhere('cle_securite', 'like', "%$search%");
            });

        if (!is_null($limit)) {
            return new CertificatCollection($query->paginate($limit, ['*'], 'page', $page));
        }

        return new CertificatCollection($query->get());
    }
}
