<?php

namespace App\Http\Requests\Api\User;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;
use App\Http\Concerns\MakeApiResponse;

class StoreRequest extends FormRequest
{
    use MakeApiResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'certificat_id' => ['sometimes', Rule::requiredIf(is_null($this->request->get('entreprise_id')))],
            'email' => ['required', 'email', 'unique:users'],
            'nom' => 'required',
            'prenoms' => 'required',
            'telephone' => ['required', 'digits:10', 'unique:users'],
            'entreprise_id' => ['sometimes', 'nullable'],
            'fonction' => 'required',
            'signer' => ['sometimes', 'required',  Rule::in([0, 1])],
            'faire_signer' => ['sometimes', 'required', Rule::in([0, 1])],
            'signer_faire_signer' => ['sometimes', 'required', Rule::in([0, 1])]
        ];
    }

    public function messages(): array
    {
        return [
            'certificat_id.required' => "Le certificat est requis",
            'email.required' => "L'adresse email est requise",
            'email.email' => "L'adresse email n'est pas valide",
            'email.unique' => "Cette adresse email a déjà été enregistrée",
            'nom.required' => "Le nom est requis",
            'prenoms.required' => "Le prénoms est requis",
            'telephone.required' => "Le numéro de téléphone est requis",
            'telephone.digits' => "Le numéro de téléphone ne doit contenir que 10 chiffres",
            'telephone.unique' => "Ce numéro de téléphone a déjà été enregistré",
            'entreprise_id.required' => "L'entreprise est requise",
            'fonction.required' => "La fonction est requise",
            'signer.required' => "Le role est requis",
            'faire_signer.required' => "Le role est requis",
            'signer_faire_signer.required' => "Le role est requis",
            'signer.in' => "Le role doit égal à 0 ou 1",
            'faire_signer.in' => "Le role doit égal à 0 ou 1",
            'signer_faire_signer.in' => "Le role doit égal à 0 ou 1",
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            $this->error($validator->errors()->toArray(), 422)
        );
    }
}
