<?php

namespace App\Http\Controllers\Api;

use App\Http\Concerns\MakeApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Entreprise\StoreRequest;
use App\Http\Requests\Api\Entreprise\UpdateRequest;
use App\Http\Resources\EntrepriseCollection;
use App\Http\Resources\UserCollection;
use App\Http\UseCases\Api\Entreprise\DeleteUseCase;
use App\Http\UseCases\Api\Entreprise\GetCollectionUseCase;
use App\Http\UseCases\Api\Entreprise\GetUserCollectionUseCase;
use App\Http\UseCases\Api\Entreprise\StoreUseCase;
use App\Http\UseCases\Api\Entreprise\UpdateUseCase;
use App\Models\Entreprise;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class EntrepriseController extends Controller
{
    use MakeApiResponse;

    public function index(Request $request, GetCollectionUseCase $useCase): EntrepriseCollection
    {
        return $useCase->handle(
            $request->query('page'),
            $request->query('limit'),
            $request->query('search')
        );
    }

    public function users(Request $request, Entreprise $entreprise, GetUserCollectionUseCase $useCase): UserCollection
    {
        return $useCase->handle(
            $entreprise,
            $request->query('page'),
            $request->query('limit')
        );
    }

    public function show(Entreprise $entreprise): JsonResponse
    {
        return $this->success($entreprise);
    }

    public function store(StoreRequest $request, StoreUseCase $useCase): JsonResponse
    {
        return $useCase->handle($request->validated());
    }

    public function update(UpdateRequest $request, Entreprise $entreprise, UpdateUseCase $useCase): JsonResponse
    {
        return $useCase->handle($entreprise, $request->validated());
    }

    public function destroy(Entreprise $entreprise, DeleteUseCase $useCase): JsonResponse
    {
        return $useCase->handle($entreprise);
    }
}
