<?php

namespace App\Http\Concerns;

use Illuminate\Http\JsonResponse;

trait MakeApiResponse
{
    public function success($message): JsonResponse
    {
        if (is_string($message)) {
            return response()->json([
                'status' => 'success',
                'message' => $message
            ]);
        }

        return response()->json($message);
    }

    public function error($message, int $code): JsonResponse
    {
        return response()->json([
            'status' => 'error',
            'message' => $message
        ], $code);
    }
}