<?php

use App\Http\Controllers\Api\ActualityController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ClientController;
use App\Http\Controllers\Api\ContactController;
use App\Http\Controllers\Api\ContactDemoController;
use App\Http\Controllers\Api\DemandedevisController;
use App\Http\Controllers\Api\GestimagesController;
use App\Http\Controllers\Api\ReferencementController;
use App\Http\Controllers\Api\UserController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::post('register', [AuthController::class, 'registerUser']);
Route::post('login', [AuthController::class, 'loginUser']);
Route::get('logout/{user}', [AuthController::class, 'logout']);

Route::get('gestimages/index', [GestimagesController::class, 'index']);

Route::get('actualities', [ActualityController::class, 'index']);
Route::get('actualities/show/{slug}', [ActualityController::class, 'show']);

Route::get('clients', [ClientController::class, 'index']);

Route::get('referencement', [ReferencementController::class, 'index']);
Route::get('referencement/show/{referencement}', [ReferencementController::class, 'show']);

Route::post('contactdemo', [ContactDemoController::class, 'store']);

Route::get('contact', [ContactController::class, 'sendContactMail']);

Route::post('demandedevis', [DemandedevisController::class, 'store']);

Route::middleware('auth:sanctum')->group(function () {
    Route::get('users', [UserController::class, 'index']);

    Route::get('gestimages', [GestimagesController::class, 'index_back']);
    Route::get('gestimages/show/{gestimagesID}', [GestimagesController::class, 'show']);
    Route::post('gestimages/store', [GestimagesController::class, 'store']);
    Route::post('gestimages/update/{gestimages}', [GestimagesController::class, 'update']);
    Route::get('gestimages/destroy/{gestimages}', [GestimagesController::class, 'destroy']);

    Route::post('actualities/store', [ActualityController::class, 'store']);
    Route::post('actualities/update/{actuality}', [ActualityController::class, 'update']);
    Route::get('actualities/destroy/{actuality}', [ActualityController::class, 'destroy']);

    Route::post('client/store', [ClientController::class, 'store']);
    Route::get('client/show/{client}', [ClientController::class, 'show']);
    Route::post('client/update/{client}', [ClientController::class, 'update']);
    Route::get('client/destroy/{client}', [ClientController::class, 'destroy']);

    Route::post('referencement/store', [ReferencementController::class, 'store']);
    Route::post('referencement/update/{referencement}', [ReferencementController::class, 'update']);
    Route::get('referencement/destroy/{referencement}', [ReferencementController::class, 'destroy']);

    Route::get('contact/index', [ContactController::class, 'index']);
    Route::get('contact/destroy/{contact}', [ContactController::class, 'destroy']);

    Route::get('contactdemo/index', [ContactDemoController::class, 'index']);
    Route::get('contactdemo/destroy/{contactdemo}', [ContactDemoController::class, 'destroy']);

    Route::get('demandedevis/index', [DemandedevisController::class, 'index']);
    Route::get('demandedevis/destroy/{demandedevis}', [DemandedevisController::class, 'destroy']);
});



?>
