<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Actuality extends Model
{
    use HasFactory;

    protected $table = 'actualities';

    protected $fillable = [
        'title',
        'content',
        'img',
        'slug',
        'posteddate',
        'subtitle',
        'alt',
    ];

    public function getTransformDateFrenchToEnglish($date)
    {
        return $this->asDateTime($date)->format('Y-m-d');
    }
}
