<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\ContactDemoStoreRequest;
use App\Mail\ContactdemoMarkdownMail;
use App\Mail\ContactdemoMarkdownMailAdmin;
use App\Models\ContactDemo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactDemoController extends Controller
{
    public function index()
    {
        $datademo = ContactDemo::orderBy('created_at', 'DESC')->get();

        return response()->json([
            'datademo' => $datademo,
            'status' => 'success',
            'response' => 'Utilisateurs demandeurs de démo chargés avec succès'
        ]);
    }

    public function store(ContactDemoStoreRequest $request)
    {
        $datademo = $request->validated();

        ContactDemo::create($datademo);

        Mail::to($datademo['email'])->send(new ContactdemoMarkdownMail($datademo));
        Mail::to('info@dkbsolutions.com')
              ->cc('astride.koffi@dkbsolutions.com')
              ->bcc('fabrice.ako@dkbsolutions.com')
              ->send(new ContactdemoMarkdownMailAdmin($datademo));
        

        return response()->json([
            'datademo' => $datademo,
            'status' => 'success',
            'response' => 'Enregistrement effectué, veuillez verifier votre mail svp !'
        ]);
    }

    public function show(ContactDemo $contactDemo)
    {
        $contactdemo = ContactDemo::where('id', $contactDemo->id)->first();

        return response()->json([
            'referencement' => $contactdemo,
            'status' => 'Success',
            'response' => 'Demandeurs de démo trouvé avec succès'
        ]);
    }

    public function destroy(ContactDemo $contactdemo)
    {
        $contactdemo->delete();

        return response()->json([
            'status' => 'success',
            'response' => 'Utilisateur demandeur de démo supprimé avec succès'
        ]);
    }

}
