<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\ClientStoreRequest;
use App\Http\Requests\ClientUpdateRequest;
use App\Models\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class ClientController extends Controller
{
    public function index()
    {
        $clients = Client::orderBy('created_at', 'DESC')->get();
        $cinqDernierClients = Client::orderBy('created_at', 'DESC')->take(5)->get();

        return response()->json([
            'clients' => $clients,
            'cinqDernierClients' => $cinqDernierClients,
            'status' => 'Success',
            'response' => 'Clients chargés avec succès'
        ]);
    }

    public function store(ClientStoreRequest $request, Client $client)
    {
        $data = $request->validated();

        $img = $data['img'];
        $filename = $img->getClientOriginalName();
        $img->move(storage_path('app/public/clients'), $filename);
        $data['img'] = $filename;

        Client::create($data);

        return response()->json([
            'data' => $data,
            'status' => 'Success',
            'response' => 'Actualité ajoutée avec succès'
        ]);
    }

    public function show(Client $client)
    {
        $client = Client::where('id', $client->id)->first();

        return response()->json([
            'client' => $client,
            'status' => 'Success',
            'response' => 'Client trouvé avec succès'
        ]);
    }

    public function update(ClientUpdateRequest $request, Client $client)
    {
        $data = $request->validated();

        $img = $request->file('img');

        if($img != null || $img != '') {
            $imgToDeleted = $client->img;
            $fileExist = File::exists(storage_path('app/public/clients/'. $imgToDeleted));

            if($fileExist) {
                // unlink(storage_path('app/public/clients/'.$imgToDeleted));
                File::delete(storage_path('app/public/clients/'.$imgToDeleted));
                $filename = $img->getClientOriginalName();
                $img->move(storage_path('app/public/clients'), $filename);
                $data['img'] = $filename;
            } else {
                $filename = $img->getClientOriginalName();
                $img->move(storage_path('app/public/clients'), $filename);
                $data['img'] = $filename;
            }

        }

        $client->update($data);

        return response()->json([
            'data' => $data,
            'status' => 'Success',
            'response' => 'Client modifiée avec succès'
        ]);
    }

    public function destroy(Client $client)
    {
        $imgToDeleted = $client->img;
        $fileExist = File::exists(storage_path('app/public/clients/'. $imgToDeleted));

        if($fileExist) {
            File::delete(storage_path('app/public/clients/'.$imgToDeleted));
            $client->delete();
        } else {
            $client->delete();
        }

        return response()->json([
            'status' => 'success',
            'response' => 'Client supprimé avec succès'
        ]);
    }
}
