"use strict";

// Class definition
var KTGeneralFullCalendarLocalesDemos = function () {
    // Private functions

    var examplelocales = function () {
        // Define variables        
        var initialLocaleCode = 'en';
        var localeSelectorEl = document.getElementById('kt_docs_fullcalendar_locale_selector');
        var calendarEl = document.getElementById('kt_docs_fullcalendar_locales');

        // initialize the calendar -- for more info please visit the official site: https://fullcalendar.io/demos
        var calendar = new FullCalendar.Calendar(calendarEl, {
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,timeGridDay,listMonth'
            },
            initialDate: '2020-09-12',
            locale: initialLocaleCode,
            buttonIcons: false, // show the prev/next text
            weekNumbers: true,
            navLinks: true, // can click day/week names to navigate views
            editable: true,
            dayMaxEvents: true, // allow "more" link when too many events
            events: [
                {
                    title: 'All Day Event',
                    start: '2020-09-01'
                },
                {
                    title: 'Long Event',
                    start: '2020-09-07',
                    end: '2020-09-10'
                },
                {
                    groupId: 999,
                    title: 'Repeating Event',
                    start: '2020-09-09T16:00:00'
                },
                {
                    groupId: 999,
                    title: 'Repeating Event',
                    start: '2020-09-16T16:00:00'
                },
                {
                    title: 'Conference',
                    start: '2020-09-11',
                    end: '2020-09-13'
                },
                {
                    title: 'Meeting',
                    start: '2020-09-12T10:30:00',
                    end: '2020-09-12T12:30:00'
                },
                {
                    title: 'Lunch',
                    start: '2020-09-12T12:00:00'
                },
                {
                    title: 'Meeting',
                    start: '2020-09-12T14:30:00'
                },
                {
                    title: 'Happy Hour',
                    start: '2020-09-12T17:30:00'
                },
                {
                    title: 'Dinner',
                    start: '2020-09-12T20:00:00'
                },
                {
                    title: 'Birthday Party',
                    start: '2020-09-13T07:00:00'
                },
                {
                    title: 'Click for Google',
                    url: 'http://google.com/',
                    start: '2020-09-28'
                }
            ]
        });

        calendar.render();

        // build the locale selector's options
        calendar.getAvailableLocaleCodes().forEach(function (localeCode) {
            var optionEl = document.createElement('option');
            optionEl.value = localeCode;
            optionEl.selected = localeCode == initialLocaleCode;
            optionEl.innerText = localeCode;
            localeSelectorEl.appendChild(optionEl);
        });

        // when the selected option changes, dynamically change the calendar option -- more info on Select2 on Change event: https://select2.org/programmatic-control/events
        $(localeSelectorEl).on('change', function () {
            if (this.value) {
                calendar.setOption('locale', this.value);
            }
        });

        calendar.render();
    }

    return {
        // Public Functions
        init: function () {
            examplelocales();
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
    KTGeneralFullCalendarLocalesDemos.init();
});
