<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('entreprises', function (Blueprint $table) {
            $table->id();
            $table
                ->foreignId('certificat_id')
                ->nullable()
                ->constrained()
                ->cascadeOnDelete();
            $table->string('raison_sociale');
            $table->string('telephone')->unique();
            $table->string('email')->unique();
            $table->boolean('otp_sms')->default(1);
            $table->timestamps();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('entreprises');
        Schema::enableForeignKeyConstraints();
    }
};
