<?php

namespace Database\Factories;

use App\Models\Signataire;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Signataire>
 */
class SignataireFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'user_id' => User::factory(),
            'nom' => null,
            'telephone' => null,
            'email' => null,
            'document' => 'fichier.pdf',
            'statut' => Signataire::STATUT_EN_ATTENTE,
            'ordre' => 0,
            'consulte' => 0,
            'positionX' => null,
            'positionY' => null,
            'page' => null,
            'motif' => null,
            'code_auth' => null
        ];
    }
}
