<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    public const ROLE_ADMIN = 'admin';
    public const ROLE_USER = 'user';

    protected $with = ['entreprise', 'certificat'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nom',
        'prenoms',
        'email',
        'password',
        'entreprise_id',
        'telephone',
        'fonction',
        'signer',
        'faire_signer',
        'signer_faire_signer',
        'role',
        'certificat_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    public function getFullName(): string
    {
        return $this->nom . ' ' . $this->prenoms;
    }

    public function entreprise(): BelongsTo
    {
        return $this->belongsTo(Entreprise::class);
    }

    public function contacts(): HasMany
    {
        return $this->hasMany(Contact::class);
    }

    public function certificat(): BelongsTo
    {
        if (is_null($this->entreprise)) {
            return $this->belongsTo(Certificat::class);
        }

        return is_null($this->certificat_id)
            ? $this->entreprise->certificat()
            : $this->belongsTo(Certificat::class);
    }

    public function isRole(string $role): bool
    {
        return $this->role === $role;
    }
}
