<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Certificat extends Model
{
    use HasFactory;

    protected $fillable = [
        'intitule',
        'cle_api',
        'cle_securite',
        'date_expiration',
        'volume_signatures_total',
        'volume_signatures_restant'
    ];

    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }

    public function entreprises(): HasMany
    {
        return $this->hasMany(Entreprise::class);
    }
}
