<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class PendingSignatureNotification extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(
        public string $url,
        public string $sender,
        public string $codeAuth
    ) {}

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject('Document(s) en attente de signature')
            ->from('no-reply@dkbsign.com', 'DKBSign')
            ->markdown('mail.signature.pending', [
                'url' => $this->url,
                'sender' => $this->sender,
                'codeAuth' => $this->codeAuth
            ]);
    }
}
