<?php

namespace App\Http\UseCases\Api\User;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\User;
use Illuminate\Http\JsonResponse;

final class UpdateUseCase extends AbstractUseCase
{
    public function handle(User $utilisateur, array $data): JsonResponse
    {
        return $utilisateur->update($data) 
            ? $this->success("L'utilisateur a été mis à jour avec succès")
            : $this->error("Echec de la mise à jour de l'utilisateur", 400);
    }
}
