<?php

namespace App\Http\UseCases\Api\Signataire;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Signataire;
use Illuminate\Http\JsonResponse;

final class ViewUseCase extends AbstractUseCase
{
    public function handle(string $token, string $document): JsonResponse
    {
        Signataire::query()
            ->where('telephone', $token)
            ->where('document', $document)
            ->update(['consulte' => 1]);
        
        return $this->success('Mise à jour effectuée');
    }
}