<?php

namespace App\Http\UseCases\Api\Signataire;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Signataire;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;
use App\Mail\RejectedSignatureNotification;

final class RejectUseCase extends AbstractUseCase
{
    public function handle(string $token, string $document, string $motif): JsonResponse
    {
        $signataire = Signataire::query()
            ->where('telephone', $token)
            ->where('document', $document)
            ->first();

        $signataire->update([
            'statut' => Signataire::STATUT_REFUSE,
            'motif' => $motif,
            'updated_at' => now()
        ]);
        
        try {
            Mail::to($signataire->user)
                ->send(
                    new RejectedSignatureNotification(
                        'https://anrmp.dkbsign.com/',
                        $signataire->nom,
                        File::basename($signataire->document),
                        $motif
                    )
                );
        } catch (Exception $e) {}

        return $this->success('Mise à jour effectuée');
    }
}