<?php

namespace App\Http\UseCases\Api\Signataire;

use App\Http\Resources\SignataireCollection;
use App\Models\Signataire;
use Illuminate\Support\Facades\DB;

final class GetCollectionUseCase
{
    public function handle(
        ?int $page = null, 
        ?int $limit = null, 
        ?string $search = null, 
        ?string $status = null, 
        ?string $start = null, 
        ?string $end = null): SignataireCollection  
    {
        $query = Signataire::query()
            ->when(!is_null($status), function ($q) use ($status) {
                return $q->where('statut', $status);
            })
            ->when(!is_null($search), function ($q) use ($search) {
                return $q->where('nom', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('telephone', 'like', "%$search%")
                    ->orWhere('document', 'like', "%$search%");
            })
            ->when(!is_null($start) && !is_null($end), function ($q) use ($start, $end) {
                return $q->where(DB::raw('date(created_at)'), '>=', $start)
                    ->where(DB::raw('date(created_at)'), '<=', $end);
            })
            ->orderBy('created_at', 'desc');
            
        if (!is_null($limit)) {
            return new SignataireCollection($query->paginate($limit, ['*'], 'page', $page));
        }

        return new SignataireCollection($query->get());
    }
}
