<?php

namespace App\Http\UseCases\Api\Signataire;

use App\Http\Services\FileUploadService;
use App\Http\Services\PDFService;
use App\Http\UseCases\Api\AbstractUseCase;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\UploadedFile;

final class FormatPDFUseCase extends AbstractUseCase
{
    public function __construct(
        private FileUploadService $fileUploadService,
        private PDFService $pdfService
    ) {}

    public function handle(UploadedFile $file): JsonResponse
    {
        if (!$this->fileUploadService->handle($file, $filename)) {
            return $this->error('Echec du téléchargement du document', 500);
        }

        $statusCode = $this->pdfService->handle($filename, $errorMessage) ? 200 : 500;

        return response()->json([
            'status' => $statusCode === 200 ? 'success' : 'error',
            'message' => $statusCode === 200 ? url('/api/public/storage') . '/' . $filename : $errorMessage
        ], $statusCode);
    }
}
