<?php

namespace App\Http\UseCases\Api\Signataire;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Signataire;
use App\Models\User;

final class AcceptUseCase extends AbstractUseCase
{
    public function __construct(
        private StoreUseCase $storeUseCase
    ) {}

    public function handle(array $data)
    {
        $signataire = Signataire::query()
            ->where('telephone', $data['token'])
            ->where('document', $data['document'])
            ->first();

        if (is_null($signataire)) {
            return $this->error('Aucun document en attente de signature', 400);
        }

        $user = User::find($signataire->user_id);
        
        return $this
            ->storeUseCase
            ->sendRequest($user, $data, $data['document'], [$signataire], true);
    }
}
