<?php

namespace App\Http\UseCases\Api\Notification;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Notification;
use Illuminate\Http\JsonResponse;

final class DeleteUseCase extends AbstractUseCase
{
    public function handle(Notification $notification): JsonResponse
    {
        return $notification->delete()
            ? $this->success('La notification a été supprimée avec succès')
            : $this->error("Echec de la suppression de la notification", 400);
    }
}