<?php

namespace App\Http\UseCases\Api\Entreprise;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Entreprise;
use Illuminate\Http\JsonResponse;

final class UpdateUseCase extends AbstractUseCase
{
    public function handle(Entreprise $entreprise, array $data): JsonResponse
    {
        return $entreprise->update($data)
            ? $this->success("L'entreprise a été mise à jour avec succès")
            : $this->error("Echec de la mise à jour de l'entreprise", 400);
    }
}
