<?php

namespace App\Http\UseCases\Api\Entreprise;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Entreprise;
use Illuminate\Http\JsonResponse;

final class DeleteUseCase extends AbstractUseCase
{
    public function handle(Entreprise $entreprise): JsonResponse
    {
        return $entreprise->delete()
            ? $this->success("L'entreprise a été supprimée avec succès")
            : $this->error("Echec de la suppression de l'entreprise", 400);
    }
}