<?php

namespace App\Http\UseCases\Api\Contact;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Contact;
use App\Models\User;
use Illuminate\Http\JsonResponse;

final class StoreUseCase extends AbstractUseCase
{
    public function handle(User $user, array $data): JsonResponse
    {
        $data['user_id'] = $user->id;
        $contact = Contact::factory()->create($data);

        return $contact
            ? $this->success('Le contact a été enregistré avec succès')
            : $this->error("Echec de l'enregistrement du contact", 400);
    }
}