<?php

namespace App\Http\UseCases\Api\Contact;

use App\Http\Resources\ContactCollection;
use App\Models\Contact;
use App\Models\User;

final class GetCollectionUseCase
{
    public function handle(User $user, ?int $page = null, ?int $limit = null, ?string $search = null): ContactCollection
    {
        $query = Contact::query()
            ->where('user_id', $user->id)
            ->when(!is_null($search), function ($q) use ($search) {
                return $q->where('nom', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('telephone', 'like', "%$search%");
            })
            ->orderBy('created_at', 'desc');

        if (!is_null($limit)) {
            return new ContactCollection($query->paginate($limit, ['*'], 'page', $page));
        }
    
        return new ContactCollection($query->get());
    }
}
