<?php

namespace App\Http\UseCases\Api\Contact;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Contact;
use Illuminate\Http\JsonResponse;

final class DeleteUseCase extends AbstractUseCase
{
    public function handle(Contact $contact): JsonResponse
    {
        return $contact->delete()
            ? $this->success('Le contact a été supprimé avec succès')
            : $this->error("Echec de la suppression du contact", 400);
    }
}