<?php

namespace App\Http\Requests\Api\Signataire;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Http\Concerns\MakeApiResponse;

class RejectRequest extends FormRequest
{
    use MakeApiResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'motif' => 'required',
        ];
    }

    public function messages(): array
    {
        return [
            'motif.required' => "Le motif de refus est obligatoire",
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            $this->error($validator->errors()->toArray(), 422)
        );
    }
}
