<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Signataire\RejectRequest;
use App\Http\Requests\Api\Signataire\StoreDocumentRequest;
use App\Http\Requests\Api\Signataire\StoreRequest;
use App\Http\Requests\Api\Signataire\UpdateRequest;
use App\Http\Requests\Api\Signataire\VerifyRequest;
use App\Http\Resources\SignataireCollection;
use App\Http\UseCases\Api\Signataire\AcceptUseCase;
use App\Http\UseCases\Api\Signataire\FormatPDFUseCase;
use App\Http\UseCases\Api\Signataire\GetCollectionUseCase;
use App\Http\UseCases\Api\Signataire\GetSignataireCollectionUseCase;
use App\Http\UseCases\Api\Signataire\GetStatisticsUseCase;
use App\Http\UseCases\Api\Signataire\RejectUseCase;
use App\Http\UseCases\Api\Signataire\StoreUseCase;
use App\Http\UseCases\Api\Signataire\ViewUseCase;
use App\Http\UseCases\Api\Signataire\VerifyUseCase;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class SignataireController extends Controller
{
    public function index(Request $request, GetCollectionUseCase $useCase): SignataireCollection
    {
        return $useCase->handle(
            $request->query('page'),
            $request->query('limit'),
            $request->query('search'),
            $request->query('status'),
            $request->query('start'),
            $request->query('end')
        );
    }

    public function show(GetSignataireCollectionUseCase $useCase, string $signataire): JsonResponse
    {
        return $useCase->handle($signataire);
    }

    public function store(StoreRequest $request, StoreUseCase $useCase): JsonResponse
    {
        return $useCase->handle($request->validated(), $request->user('sanctum'));
    }

    public function accept(UpdateRequest $request, AcceptUseCase $useCase): JsonResponse
    {
        $data = $request->validated();
        $data['token'] = $request->get('token');
        $data['document'] = $request->get('document');

        return $useCase->handle($data);
    }

    public function reject(RejectRequest $request, RejectUseCase $useCase): JsonResponse
    {
        return $useCase->handle(
            $request->get('token'),
            $request->get('document'),
            $request->input('motif')
        );
    }

    public function verify(VerifyRequest $request, VerifyUseCase $useCase, string $signataire): JsonResponse
    {
        return $useCase->handle($signataire, $request->validated());
    }

    public function format(StoreDocumentRequest $request, FormatPDFUseCase $useCase): JsonResponse
    {
        return $useCase->handle($request->file('document'));
    }

    public function statistics(Request $request, GetStatisticsUseCase $useCase): JsonResponse
    {
        return $useCase->handle(
            $request->query('start'),
            $request->query('end')
        );
    }

    public function view(Request $request, ViewUseCase $useCase): JsonResponse
    {
        return $useCase->handle(
            $request->get('token'),
            $request->get('document')
        );
    }
}
