<?php

namespace App\Http\Controllers\Api;

use App\Http\Concerns\MakeApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Certificat\StoreRequest;
use App\Http\Requests\Api\Certificat\UpdateRequest;
use App\Http\Resources\CertificatCollection;
use App\Http\UseCases\Api\Certificat\DeleteUseCase;
use App\Http\UseCases\Api\Certificat\GetCollectionUseCase;
use App\Http\UseCases\Api\Certificat\StoreUseCase;
use App\Http\UseCases\Api\Certificat\UpdateUseCase;
use App\Models\Certificat;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CertificatController extends Controller
{
    use MakeApiResponse;

    public function index(Request $request, GetCollectionUseCase $useCase): CertificatCollection
    {
        return $useCase->handle(
            $request->query('page'),
            $request->query('limit'),
            $request->query('search')
        );
    }

    public function show(Certificat $certificat): JsonResponse
    {
        return $this->success($certificat);
    }

    public function store(StoreRequest $request, StoreUseCase $useCase): JsonResponse
    {
        return $useCase->handle($request->validated());
    }

    public function update(UpdateRequest $request, Certificat $certificat, UpdateUseCase $useCase): JsonResponse
    {
        return $useCase->handle($certificat, $request->validated());
    }

    public function destroy(Certificat $certificat, DeleteUseCase $useCase): JsonResponse
    {
        return $useCase->handle($certificat);
    }
}
