<?php

namespace App\Http\Controllers\Api;

use App\Http\Concerns\MakeApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Auth\LoginRequest;
use App\Http\UseCases\Api\Authentication\LoginUseCase;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    use MakeApiResponse;

    public function login(LoginRequest $request, LoginUseCase $useCase): JsonResponse
    {
        return $useCase->handle($request->validated());
    }

    public function logout(Request $request): JsonResponse
    {
        $request->user('sanctum')->tokens()->delete();
        return $this->success('Déconnexion réussie');
    }
}
