<?php

namespace App\Console\Commands;

use App\Models\Entreprise;
use App\Notifications\RenouvellementCertificatNotification\AdminNotification;
use App\Notifications\RenouvellementCertificatNotification\EntrepriseNotification;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Notification;

class RappelRenouvellementCertificat extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reminder:certificat';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = "Envoie une notification de renouvellement de certificat chaque semaine, un mois avant la date d'expiration";

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $entreprises = Entreprise::all();

        foreach ($entreprises as $entreprise) {
            $remainingMonths = now()
                ->monthsUntil($entreprise->certificat->date_expiration)
                ->toArray();

            // À un mois de la date d'expiration
            if (count($remainingMonths) === 1) {
                $remainingWeeks = now()
                    ->weeksUntil($entreprise->certificat->date_expiration)
                    ->toArray();

                $weeks = array_map(fn ($week) => $week->toDateString(), $remainingWeeks);

                if (in_array(now()->toDateString(), $weeks)) {
                    Notification::route('mail', $entreprise->email)
                        ->notify(new EntrepriseNotification(count($weeks)));

                    Notification::route('mail', 'infos@dkbsign.com')
                        ->notify(new AdminNotification(count($weeks), $entreprise->raison_sociale));
                }
            }
        }

        return Command::SUCCESS;
    }
}
