<?php

namespace App\Http\Controllers\Api;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use Illuminate\Support\Str;
use App\Http\Requests\Auth\RegisterRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    /**
     * Login The User
     * @param Request $request
     * @return User
    */
    public function loginUser(LoginRequest $request)
    {
        $data = $request->validated();
        $user = User::where('email', $data['email'])->first();

        if (!$user || !Hash::check($data['password'], $user->password)) {
            return response()->json([
                'status' => 'failed',
                'response' => 'Email ou mot de passe incorrect'
            ], 401);
        }

        return response()->json([
            'status' => 'success',
            'response' => [
                'token' => $user->createToken(Str::random(15))->plainTextToken,
                'user' => $user
            ]
        ]);
    }

    public function logout(User $user)
    {
        $user->tokens()->delete();

        return response()->json([
            'status' => 'success',
            'response' => 'Déconnexion réussie'
        ]);
    }

    public function registerUser(RegisterRequest $request)
    {
        $data = $request->validated();
        $data['password'] = bcrypt($data['password']);

        User::create($data);

        return response()->json([
            'data' => $data,
            'status' => true,
            'response' => 'Utilisateur enregistré avec succès'
        ]);
    }


}
