<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactdemoMarkdownMail extends Mailable
{
    use Queueable, SerializesModels;

    public $datademo = [];

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Array $contactdemoInfos)
    {
        $this->datademo = $contactdemoInfos;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from('no-reply@dkbsign.com')
                    ->subject('Demande démo DKBSign')
                    ->markdown('emails.contactdemoMarkdown');
    }
}
