<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DemandedevisStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'fullname' => 'required',
            'company' => 'required',
            'activitysector' => 'required',
            'contact' => 'required',
            'email' => 'required',
            'description' => 'required',
            'signvolume' => ['sometimes',''],
        ];
    }

    public function messages()
    {
        return [
            'fullname.required' => 'Le champ fullname est obligatoire',
            'company.required' => 'Le champ company est obligatoire',
            'activitysector.required' => 'Le champ activitysector de l\'entreprise est obligatoire',
            'contact.required' => 'Le champ contact est obligatoire',
            'email.required' => 'Le champ email est obligatoire',
            'description.required' => 'Le champ description est obligatoire',
        ];
    }
}
