<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class ContactDemoStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nom' => 'required',
            'prenom' => 'required',
            'email' => 'required',
            'contact' => 'required',
            'entreprise' => 'required',
            'fonction' => 'required',
            'motif' => 'required',
            'datedemo' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'nom.required' => 'Le champ nom est obligatoire',
            'prenom.required' => 'Le champ prenom est obligatoire',
            'email.required' => 'Le champ email est obligatoire',
            'contact.required' => 'Le champ contact est obligatoire',
            'entreprise.required' => 'Le champ nom de l\'entreprise est obligatoire',
            'fonction.required' => 'Le champ fonction est obligatoire',
            'motif.required' => 'Le champ motif de demande est obligatoire',
            'datedemo.required' => 'Le champ date de démo est obligatoire',
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(response()->json([
            'status' => 'failed',
            'response' => $validator->errors()
        ], 422));
    }
}
